
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PED_CP_PARAM_PRC_FILIAL]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PED_CP_PARAM_PRC_FILIAL]
GO

 
CREATE FUNCTION [dbo].[UFD_EST_PED_CP_PARAM_PRC_FILIAL]  ()    
              
	RETURNS @RS_TAB_PARAM_RET TABLE (
				CD_EMP				INT,
				CD_PED_CP_PARAM		INT,
				FLAG_TODAS_FILIAIS	INT,								
				CD_FILIAL			INT)  
						
  
AS    
BEGIN              
			    
	 DECLARE @RS_TAB_ATIVA AS TABLE (
				CD_EMP				INT,    
				CD_PED_CP_PARAM		INT,
				FLAG_TODAS_FILIAIS	INT)    
    
	 -------------------------------------------------------------------------------------------------------------------------------    
	 --Consultando as tbls de parâmetro ativas e no roteiro do dia
	 -------------------------------------------------------------------------------------------------------------------------------    
	 INSERT INTO @RS_TAB_ATIVA     
				SELECT    
					CP_PARAM.CD_EMP,
					CP_PARAM.CD_PED_CP_PARAM,
					CP_PARAM.FLAG_TODAS_FILIAIS					
				FROM EST_PED_CP_PARAM CP_PARAM 			
				WHERE 
					CP_PARAM.STS_PED_CP_PARAM =0
					AND EXISTS (SELECT ROT.CD_PED_CP_PARAM 
								FROM EST_PED_CP_ROTEIRO_CP_EST_PED_CP_PARAM ROT
									INNER JOIN EST_PED_CP_ROTEIRO_CP_AGD_SEMANA ROT_AGD ON 
										ROT.CD_ROTEIRO = ROT_AGD.CD_ROTEIRO
								WHERE ROT.CD_PED_CP_PARAM = CP_PARAM.CD_PED_CP_PARAM
									  AND ROT.CD_EMP 		= CP_PARAM.CD_EMP 
									  AND ROT_AGD.CD_DIA 	= DATEPART(DW, GETDATE()))
										  

	------------------------------------------------------------------------------------------------------------------------------    
	--Montando tabela de retorno    
	-------------------------------------------------------------------------------------------------------------------------------   
	INSERT INTO @RS_TAB_PARAM_RET     
				SELECT 
					RS_TAB_ATIVA.CD_EMP,
					RS_TAB_ATIVA.CD_PED_CP_PARAM,					
					RS_TAB_ATIVA.FLAG_TODAS_FILIAIS,										
					CP_PARAM_FILIAL.CD_FILIAL  
				FROM @RS_TAB_ATIVA RS_TAB_ATIVA 				
					INNER JOIN EST_PED_CP_PARAM_PRC_FILIAL CP_PARAM_FILIAL ON 
						RS_TAB_ATIVA.CD_EMP					= CP_PARAM_FILIAL.CD_EMP					
						AND RS_TAB_ATIVA.CD_PED_CP_PARAM	= CP_PARAM_FILIAL.CD_PED_CP_PARAM	
				WHERE 				
					RS_TAB_ATIVA.FLAG_TODAS_FILIAIS = 0		

				UNION 
				
				SELECT 
					RS_TAB_ATIVA.CD_EMP,
					RS_TAB_ATIVA.CD_PED_CP_PARAM,										
					RS_TAB_ATIVA.FLAG_TODAS_FILIAIS,														
					0 AS CD_FILIAL  
				FROM @RS_TAB_ATIVA RS_TAB_ATIVA 
				WHERE 				
					RS_TAB_ATIVA.FLAG_TODAS_FILIAIS = 1
      
	RETURN    
END      
      


